import java.io.IOException;
import java.util.Iterator;

import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.tree.*;

public class Main {

	public static void main(String[] args) throws IOException {

		// create a CharStream that reads from standard input
		ANTLRInputStream input = new ANTLRInputStream("UNION(JOIN(A,B),ATOV(h(X,Y), C)).");
		// create a lexer that feeds off of input CharStream
		RelationalAlgebraLexer lexer = new RelationalAlgebraLexer(input);
		// create a buffer of tokens pulled from the lexer
		CommonTokenStream tokens = new CommonTokenStream(lexer);
		// create a parser that feeds off the tokens buffer
		RelationalAlgebraParser parser = new RelationalAlgebraParser(tokens);
		ParseTree context = parser.prog(); // begin parsing at init rule
		TerminalListener listener = new TerminalListener();
		ParseTreeWalker.DEFAULT.walk(listener, context);
		System.out.println("-----------------------");
		String res = "";
		for (Iterator<TerminalNode> iterator = listener.terminalsSet.iterator(); iterator.hasNext();) {
			TerminalNode arg = (TerminalNode) iterator.next();
			res += arg.getText() + " ";
		}
		System.out.println(res);
//		res = "";
//		for (Iterator<RelationalAlgebraParser.ExprContext> iterator = listener.exprList.iterator(); iterator.hasNext();) {
//			RelationalAlgebraParser.ExprContext arg = (RelationalAlgebraParser.ExprContext) iterator.next();
//			res += arg.getText() + " ";
//		}
//		System.out.println(res);
	}

}

